# ==========================================================================
# Replication Do File
# Zubek/Klver: Legislative pledges and coaliton government, Party Politics
# ==========================================================================
  

library(Design)
library(Hmisc)
library(foreign)
library(nlme)
library(lattice)
library(Matrix)
library(lme4)
library(car)
library(arm)
library(memisc)
library(mice)
library(Zelig)
library(Amelia)
library(plotrix)      
options(scipen=3)     
library(readstata13)


# ============
# Figure 1
# ============

# Percentage of adopted laws  (Figure 1)
adopt_pc <- c(40.65, 41.09, 30, 16.67, 25.93, 39.13, 41.09)

win.metafile(file="C:/Users/klueverh/Dropbox/Dokumente/Papers/Legislative programme paper/Replication/fig1.emf", height=8, width=11) 
barplot(adopt_pc, cex=1.5, cex.axis=2.0, cex.lab=2.0, ylim=c(0,100), xlab= "Percentage of adopted bills per legislative programme", 
names.arg=c("1", "2", "3", "4", "5", "6", "7"))
dev.off()



# ============
# Figure 2
# ============

rm(list=ls(all=TRUE))
setwd("C:/Users/klueverh/Dropbox/Dokumente/Papers/Legislative programme paper/Replication")
durdata <- read.dta13("Zubek_Kluever_unique.dta")



win.metafile(file="C:/Users/klueverh/Dropbox/Dokumente/Papers/Legislative programme paper/Replication/fig2.emf", height=8, width=11) 
 hist(durdata$days, breaks = 8, main = "", col="grey60", xlab = "Decision-making time in days", ylab = "Frequency", 
      cex=1.5, cex.axis=2.0, cex.lab=2.0)
dev.off()




# Logistic regression predicted probability graphs
# ================================================
rm(list=ls(all=TRUE))
setwd("C:/Users/klueverh/Dropbox/Dokumente/Papers/Legislative programme paper/Replication")
fixeff_raw <- read.csv("fixeff.csv")
fixeff_untransposed <- fixeff_raw[1,]
fixeff <- t(fixeff_untransposed)
varcov_raw <- read.csv("varcov.csv")
varcov <- varcov_raw[1:9,]



# Preparing the graphs
# ====================

# Step 1: get b and V
(b <- as.vector(fixeff))		        
(V <- as.matrix(varcov))		      
(sqrt(diag(V)))                         



# Step 2: Set up MVN distribution
nsim <- 1000
mvn <- mvrnorm(nsim, mu=b, Sigma=V)         


# Step 3: Get coefficients
dat <- read.dta13("Rdata.dta")
attach(dat)


data <- na.omit(data.frame(cbind(adopted_sixmon, sal_new, dist_new, minload, staffReal, po, amendment, eu, quarter, program2, program3, program4, program5, program6, program7)))
str(data) 
 

# ======================
# Figure 3
# ======================


# Step 4: Computing predicted probabilities
lobside_hat <- list(rep(NA,11))
for (i in 1:11){
lobside_hat[[i]] = (
              mvn[,1] * i
            + mvn[,2] *  (mean(data$dist_new)) 
            + mvn[,3] *  (mean(data$minload))
            + mvn[,4] *  (mean(data$staffReal))
            + mvn[,5] *  (median(data$po))
            + mvn[,6] *  (median(data$amendment))
            + mvn[,7] *  (median(data$eu))
            + mvn[,8] *  (mean(data$quarter))
            + mvn[,9] * 1
            )
}

str(lobside_hat)



# Transform lists into matrixes
lobside_hat_matrix <- do.call(cbind, lobside_hat)    
lobside_hat_matrix[,1]



# Loop to calculate probabilities
lobside_hat_prob <- list(rep(NA,11))
for (i in 1:11){
  lobside_hat_prob[[i]] <- exp(lobside_hat_matrix[,i]) / (1 + exp(lobside_hat_matrix[,i]))
}
str(lobside_hat_prob)

lobside_hat_prob_matrix <- do.call(cbind, lobside_hat_prob)     



# Taking the means and quantiles of simulated values
prob_lobside_hat_mean <- list(rep(NA,11))
prob_lobside_hat_lb <- list(rep(NA,11))
prob_lobside_hat_ub <- list(rep(NA,11))

for (i in 1:11){
 prob_lobside_hat_mean[[i]] <- mean(lobside_hat_prob_matrix[,i])
 prob_lobside_hat_lb[[i]] <- quantile(lobside_hat_prob_matrix[,i], c(.025))
 prob_lobside_hat_ub[[i]] <- quantile(lobside_hat_prob_matrix[,i], c(.975))
}



# Getting the values together for the plot
lobrange <- 1:11
mean <- unlist(prob_lobside_hat_mean)
lb <- unlist(prob_lobside_hat_lb)
ub <- unlist(prob_lobside_hat_ub)



# Plotting predicted probabilites 
win.metafile(file="C:/Users/klueverh/Dropbox/Dokumente/Papers/Legislative programme paper/Replication/fig3.emf", height=8, width=11)
par(mfrow=c(1,1),mar=c(5,5,1.5,3))     
plot(1, type="n",  xlim=c(1,11), ylim=c(0,1), xlab="Salience",
      ylab="Predicted probability of adoption", cex=1.5, cex.axis=2.0, cex.lab=2.5)
      lines(mean, col="black", lwd=2)
      lines(ub, col="black", lty=2, lwd=2)
      lines(lb, col="black", lty=2, lwd=2)
      legend(55, 0.12, bty = "n", "Point estimate", lwd=2, col="black", cex=1.5)
      legend(55, 0.07, bty = "n", "95% Confidence interval", lwd=2, lty=2, col="black", cex=1.5)
dev.off()





# ======================
# Figure 4
# ======================



# Step 4: Computing predicted probabilities
lobside_hat <- list(rep(NA,11))
for (i in 1:11){
lobside_hat[[i]] = (
              mvn[,1] *  (mean(data$sal_new))
            + mvn[,2] *  i
            + mvn[,3] *  (mean(data$minload))
            + mvn[,4] *  (mean(data$staffReal))
            + mvn[,5] *  (median(data$po))
            + mvn[,6] *  (median(data$amendment))
            + mvn[,7] *  (median(data$eu))
            + mvn[,8] *  (mean(data$quarter))
            + mvn[,9] * 1
            )
}

str(lobside_hat)



# Transform lists into matrixes
lobside_hat_matrix <- do.call(cbind, lobside_hat)    
lobside_hat_matrix[,1]



# Loop to calculate probabilities
lobside_hat_prob <- list(rep(NA,11))
for (i in 1:11){
  lobside_hat_prob[[i]] <- exp(lobside_hat_matrix[,i]) / (1 + exp(lobside_hat_matrix[,i]))
}
str(lobside_hat_prob)

lobside_hat_prob_matrix <- do.call(cbind, lobside_hat_prob)     



# Taking the means and quantiles of simulated values
prob_lobside_hat_mean <- list(rep(NA,11))
prob_lobside_hat_lb <- list(rep(NA,11))
prob_lobside_hat_ub <- list(rep(NA,11))

for (i in 1:11){
 prob_lobside_hat_mean[[i]] <- mean(lobside_hat_prob_matrix[,i])
 prob_lobside_hat_lb[[i]] <- quantile(lobside_hat_prob_matrix[,i], c(.025))
 prob_lobside_hat_ub[[i]] <- quantile(lobside_hat_prob_matrix[,i], c(.975))
}



# Getting the values together for the plot
lobrange <- 1:11
mean <- unlist(prob_lobside_hat_mean)
lb <- unlist(prob_lobside_hat_lb)
ub <- unlist(prob_lobside_hat_ub)



# Plotting predicted probabilites 
win.metafile(file="C:/Users/klueverh/Dropbox/Dokumente/Papers/Legislative programme paper/Replication/fig4.emf", height=8, width=11)
par(mfrow=c(1,1),mar=c(5,5,1.5,3))     
plot(1, type="n",  xlim=c(1,11), ylim=c(0,1), xlab="Divisiveness",
      ylab="Predicted probability of adoption", cex=1.5, cex.axis=2.0, cex.lab=2.5)
      lines(mean, col="black", lwd=2)
      lines(ub, col="black", lty=2, lwd=2)
      lines(lb, col="black", lty=2, lwd=2)
      legend(55, 0.12, bty = "n", "Point estimate", lwd=2, col="black", cex=1.5)
      legend(55, 0.07, bty = "n", "95% Confidence interval", lwd=2, lty=2, col="black", cex=1.5)
dev.off()




